uniform sampler2D s_tex0;
uniform float intensity;
uniform float roughness;
uniform float darkness;
uniform float time;
uniform vec2 size;

uniform vec4 u_blendcolor;

varying vec4 v_texcoord[5/2];

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(1.29898,.78233))) * 43758.5453);
}

// From http://www.geeks3d.com/20100909/shader-library-gaussian-blur-post-processing-filter-in-glsl/

void main()
{
//	vec3 offset = vec3( 0.0, 1.3846153846, 3.2307692308 );
//	vec3 weight = vec3( 0.2270270270, 0.3162162162, 0.0702702703 );
	float weight[5];
	weight[0] = 0.0;
	weight[1] = 0.0;
	weight[2] = 0.0;
	weight[3] = 0.0;
	weight[4] = 0.0;

	float vx_offset = 0.1;
	vec4 color = vec4(0.,0.,0.,0.);

	int samples = 5;
	for (int i=0; i<samples/2; i++)
	{
		  color.rgb += texture2D(s_tex0, v_texcoord[i].xy).rgb * weight[i*2];
		  color.rgb += texture2D(s_tex0, v_texcoord[i].zw).rgb * weight[i*2+1];
	}

	// bloom effect inspired by http://kstudios.de/postprocessing2_3.php
	// vec3 origColor = color.rgb;
	// color.rgb = color.rgb*color.rgb;

	// average is darkened via factor
	// float avg = (color.r+color.g+color.b)/3.0;
//	avg = avg * (1.0-roughness) + avg * rand(v_texcoord*time)*roughness;
	// avg /= 1.+darkness;
	// color.rgb = vec3(avg,avg,avg);
	// color.rgb += origColor.rgb;


	// feed it back according to http://kstudios.de/postprocessing2_3.php
//	color.rgb = mix(color, tc, intensity);

	gl_FragColor = color;
}
